//								EJEMPLO 20
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//El teclado y el LCD.
//
//Haciendo uso de las rutinas incluidas en los ficheros KBD2.C y LCD2.C, se trata 
//de leer el teclado y, visualizar sobre el mdulo LCD  la tecla pulsada.
//
//El ejemplo pretende mostrar cmo es posible gobernar dos perifricos distintos conectados
//a la misma puerta (LCD y teclado). Para ello basta reprogramarla dinmicamente en el 
//tiempo segn sea necesario.

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)
#use delay(clock=4000000)
#include <kbd2.c>		//Incluir funciones de manejo del teclado
#include <lcd2.c>		//Incluir funciones de manejo del LCD

char tecla;

main()
{  
	SETUP_ADC_PORTS(NO_ANALOGS);//Puerta A Digital
	set_tris_a(0x3F);		//RA0-RA5 entradas
	set_tris_b(0x00);		//RB0-RB7 salidas	   
	lcd_init();				//Secuencia de inicio del LCD
	printf(lcd_putc,"Se ha pulsado: "); //Mensaje en el LCD

	while(1)
	{	do
		{
		tecla=kbd_getc();	//Lee el teclado
		}while (tecla==0);	//Espera que haya alguna pulsada
		lcd_gotoxy(16,1);	//Posiciona el cursor
		lcd_putc(tecla);	//Visualiza la tecla pulsada
	}
}	
